require( "HiddenObject/script/style.lua" );

FooterGraphics = {
	"HiddenObject/UI/Button/footerbuttonup",
	"HiddenObject/UI/Button/footerbuttondown",
	"HiddenObject/UI/Button/footerbuttonrollover",
};	

FooterStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	graphics = FooterGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};



YesNoText =
 {
	parent=DefaultStyle,
	font = YesNoFont,
	flags = kVAlignCenter + kHAlignCenter,
	x=0,y=46,w=kMax,h=kMax-60
};

DialogTitleFont = {
  standardFont,
  32,
  Color(131, 167, 184, 255),
};


DialogTitleText = {
	parent=DefaultStyle,
	font = DialogTitleFont,
	flags = kVAlignCenter + kHAlignCenter,
	x=16,y=12,w=kMax,h=30
};

DialogBodyFont = {
  standardFont,
  24,
  WhiteColor
};

DialogBodyText = {
	parent=DefaultStyle,
	font = DialogBodyFont,
	flags = kVAlignCenter + kHAlignCenter,
	x=0,y=46,w=kMax,h=kMax-60
};


function GetWindowX()

	x = kCenter;
	if IsMainMenu() then x = 342; end
	return x;
end



function GetWindowY()

	y = kCenter - 45;
	if IsMainMenu() then y = 160; end
	return y;
end

MakeDialog
{
	name="resetyesNoDialog", 
    Bitmap
    {
		image="HiddenObject/UI/Background/smalldialog",
		x = GetWindowX(),
		y = GetWindowY(),
		

		SetStyle(DialogTitleText),
        Text
		{
			name = "resetyesnotitle",
			label= "resetyesnotitle",
			font = DialogTitleFont,
			x = kCenter,
			y = 20,
			h = 36,
		};
		
		SetStyle(DialogBodyText),
		Text
		{
			name = "resetyesnobody",
			label= "resetyesnobody",
		};

		SetStyle(FooterStyle);
        Button
        {
			command=
				function()					
					SendGameMessage('resetgame');
					PopModal('resetyesNoDialog');
					SwapToModal('HiddenObject/Script/hiddenobjectgame.lua');
				end;
            flags = 5,
            label = "yes",
            name = "reset_yes",
            font = StandardButtonFont,
            x = kCenter-80,
            y = -80,
        },

        Button
        {
			command=
				function()
					SendGameMessage('resetgame_no');
                end;
            close = true,
            font = StandardButtonFont,
            flags = 5,
            label = "no",
            name = "reset_no",
            x = kCenter+80,
            y = -80,
        },
        
    },

} -- MakeDialog
